/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.gui.preview;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class WorldBlockCapture {
    private final Level world;
    private final Map<BlockPos, BlockPos> blocks = Maps.newHashMap();

    public WorldBlockCapture(Level world) {
        this.world = world;
    }

    public void putBlock(BlockPos capturePos, BlockPos worldPos) {
        this.blocks.put(capturePos, worldPos);
    }

    public BlockState getBlockState(BlockPos pos) {
        BlockPos worldPos = this.blocks.get(pos);
        return worldPos == null ? Blocks.f_50016_.m_49966_() : this.world.m_8055_(worldPos);
    }

    public BlockEntity getBlockEntity(BlockPos pos) {
        BlockPos worldPos = this.blocks.get(pos);
        return worldPos == null ? null : this.world.m_7702_(worldPos);
    }

    public Iterable<BlockPos> getBlockLocations() {
        return this.blocks.values();
    }

    public AABB getBounds() {
        if (this.blocks.isEmpty()) {
            return new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        AABB bounds = new AABB((BlockPos)this.blocks.keySet().stream().findFirst().get());
        for (BlockPos pos : this.blocks.keySet()) {
            bounds = bounds.m_82367_(new AABB(pos));
        }
        return bounds;
    }

    @Deprecated
    public Level getWorld() {
        return this.world;
    }
}

